/* JAlbum tool that strips some textual xmp metadata from files */

Work work = Work.on(TreeCollection.of(selectedObjects).parallelStream().filter(ao -> ao.xmpManager != null))
.titled("Strip xmp data")
.inform("This script strips some items from the xmp section of selected files")
.forEach(ao) -> {
	XmpManager mgr = ao.getXmpManager();
	mgr.getXMPMeta().deleteProperty(XmpManager.dc_NS, "dc:description");
	mgr.getXMPMeta().deleteProperty(XmpManager.dc_NS, "dc:title");
	mgr.getXMPMeta().deleteArrayItem(XmpManager.dc_NS, "dc:creator", 1);
	mgr.getXMPMeta().deleteProperty(XmpManager.dc_NS, "dc:rights");
	mgr.save();
}
.execute(work) -> {
	// Refresh display
	explorer.context.viewFolder(explorer.context.currentFolder);	
	window.statusBar.setText("Processed ${work.processed} objects");
}
.showResult();
